
// BIEstimate.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPEstimate.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIEstimate.h"
#endif
#import "BIAppVersioning.h"


/*!
    @class       BIEstimate
    @abstract    BIEstimate represents an Estimate which would be sent to a customer.  It is essentially a snapshot of proposed work with estimated amount of time to do work, costs, taxes, etc.
    @discussion  BIEstimate has a to-many to estimate slips.  Note that we simply have a reference to these estimate slips as slips can be associated with numerous estimates.
 
                 ISSUES
           
                 - a slip is associated with numerous estimates.  This means that if you change a value of an estimate slip, the previous estimate will then take on this change.  Although we do not expose estimates to the end user, we only expose the PDF, this would cause a problem if we were to change this functionality.  The obvious change is that once an estimate has been sent, you should no longer be able to modify the specifics of a slip.  You should dupe it, and then change it.  We should investigate this.
  
                 - we should move out the subtotal, markup, discount, total logic out to another class which soley handles this.
 
                 - we should move out the tax calculation to the tax manager seems logical.
 
                 - we should remove all the old tax calculation stuff... ie. why is tax1 and tax2 still here?
*/


enum {
	BIESTIMATE_NOTSENT_STATE = 101,
	BIESTIMATE_SENT_STATE = 102,
	BIESTIMATE_ACCEPTED_STATE = 103,
	BIESTIMATE_REJECTED_STATE = 104
};

@class BIClient;

@interface BIEstimate : BL_SUPER_CLASSNAME_MUNGE(Estimate) 
{
}

@property (nonatomic, readonly) NSNumber *total;

- (void)setDefaultValues;
- (void)setDefaultValuesWithObjectContext:(MCPObjectContext*)oc;

- (NSNumber*)subTotalPlusMarkup;
- (void)setSubTotalPlusMarkup:(NSNumber*)aTotal;

- (NSNumber*)subTotalPlusMarkupMinusDiscount;
- (void)setSubTotalPlusMarkupMinusDiscount:(NSNumber*)aTotal;

- (NSNumber*)subTotal;
- (void)setSubTotal:(NSNumber*)aTotal;

- (NSNumber*)total;
- (void)setTotal:(NSNumber*)aTotal;

- (NSNumber *)calculateAndCacheTotal:(BOOL)cacheTotal;

//- (NSNumber*)totalTax1;
//- (void)setTotalTax1:(NSNumber*)aTotal;
//
//- (NSNumber*)totalTax2;
//- (void)setTotalTax2:(NSNumber*)aTotal;

- (NSNumber*)tax1Total;
- (void)setTax1Total:(NSNumber*)aTotal;

- (NSNumber*)tax2Total;
- (void)setTax2Total:(NSNumber*)aTotal;


- (NSNumber*)combinedTaxTotal;
- (void)setCombinedTaxTotal:(NSNumber*)aTotal;

//- (NSNumber*)totalMarkup;
//- (void)setTotalMarkup:(NSNumber*)aTotal;

- (NSNumber*)markupTotal;
- (void)setMarkupTotal:(NSNumber*)aTotal;
- (NSNumber*)calculateMarkupTotalOnTotal:(NSNumber*)aSubtotal;

- (NSNumber*)discountTotal;
- (void)setDiscountTotal:(NSNumber*)aTotal;
- (NSNumber*)calculateDiscountTotalOnTotal:(NSNumber*)aSubtotal;

- (BOOL)isDueDate;
- (void)setIsDueDate:(BOOL)flag;

- (NSString*)numSlipsString;
- (void)setNumSlipsString:(NSString*)aString;

- (NSArray*)billableSlips;
- (void)setBillableSlips:(NSArray*)theSlips;

- (BOOL)useTax1Bool;
- (void)setUseTax1Bool:(BOOL)aFlag;

- (BOOL)useTax2Bool;
- (void)setUseTax2Bool:(BOOL)aFlag;

- (BOOL)compoundSecondaryTaxBool;
- (void)setCompoundSecondaryTaxBool:(BOOL)aFlag;

- (NSNumber*)taxesTotal;
- (void)setTaxesTotal:(NSNumber*)aNum;

- (NSNumber*)markupTotalAsPercentageOfEstimate;
- (NSNumber*)discountTotalAsPercentageOfEstimate;

- (NSArray*)appliedTaxes;
- (void)setAppliedTaxes:(NSArray*)taxes;

- (NSArray*)combineAppliedTaxesWithSameNameAndRate:(NSArray*)appliedTaxes;

- (NSNumber*)subTotalNotIncludingMarkupAndDiscountFromSlips;
- (void)setSubTotalNotIncludingMarkupAndDiscountFromSlips:(NSNumber*)aTotal;

- (NSArray*)consolidateLikeTaxes:(NSArray*)taxesTotalArray;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (BIClient *)client;

- (NSCalendarDate *)dateForAccount;

- (NSNumberFormatter *)currencyFormatter;

- (NSString *)objectNumber;

@end
